PACKAGE p_ram IS
  TYPE t_ram_data IS ARRAY(0 TO 511) OF INTEGER;

  CONSTANT x_val : INTEGER := -1;
  CONSTANT z_val : INTEGER := -2;
END p_ram;

USE WORK.p_ram.ALL;
LIBRARY IEEE; USE IEEE.std_logic_1164.ALL;
ENTITY ram IS
  PORT( data_in : IN INTEGER;
        addr : IN INTEGER;
        data : OUT INTEGER;
        cs : IN std_logic;
        r_wb: in std_logic);
END ram;

ARCHITECTURE behave_ram OF ram IS
BEGIN
  main_proc: PROCESS( cs, addr, r_wb )
    VARIABLE ram_data : t_ram_data;
    VARIABLE ram_init : boolean := false;
  BEGIN
    IF NOT(ram_init) THEN
      FOR i IN ram_data'LOW TO ram_data'HIGH LOOP
        ram_data(i) := 0;
      END LOOP;

      ram_init := TRUE;
    END IF;

    IF (cs = 'X') OR (r_wb = 'X')THEN
      data <= x_val;

    ELSIF ( cs = '0' ) THEN
      data <=z_val;

    ELSIF (r_wb = '1') THEN
      IF (addr = x_val) OR (addr = z_val) THEN
        data <=x_val;
      ELSE
        data <= ram_data(addr);
      END IF;

    ELSE
      IF (addr = x_val) OR (addr = z_val) THEN
        ASSERT FALSE 
          REPORT " writing to unknown address"
          SEVERITY ERROR;
        data <= x_val;
      ELSE
        ram_data(addr) :=data_in;
        data <= ram_data(addr);
      END IF;

    END IF;
  END PROCESS;
END behave_ram;


